/*******************************************************************
*
*  DESCRIPTION:
*
*  AUTHOR:
*
*  EMAIL:
*
*  DATE:
*
*******************************************************************/

/** include files **/
#include "aisleUnlocked.h"      // class AisleUnlocked
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )

/** public functions **/

/*******************************************************************
* Function Name:
* Description:
********************************************************************/
AisleUnlocked::AisleUnlocked( const string &name )
: Atomic( name )
, reset( addInputPort( "reset" ) )
, onExit( addInputPort( "onExit" ) )
, onReset( addOutputPort( "onReset" ) )
, stop( addOutputPort( "stop" ) )
, preparationTime( 0, 0,15, 0 )


{
}

/*******************************************************************
* Function Name: initFunction
* Description:
* Precondition:
********************************************************************/
Model &AisleUnlocked::initFunction()
{
	holdIn( passive, Time::Zero );
	ifExit = false ;
	ifReset = false;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &AisleUnlocked::externalFunction( const ExternalMessage &msg )
{

	if ( msg.port() == onExit )
		{
					ifExit = true ;
		}


		else if ( msg.port() == reset )
		{
				ifReset = true ;

		}

		holdIn( active, Time::Zero );

		return *this ;
	}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &AisleUnlocked::internalFunction( const InternalMessage & )
{

		ifExit = false ;
		ifReset = false ;
		passivate() ;

		return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &AisleUnlocked::outputFunction( const InternalMessage &msg )
{
		if ( ifExit == true )
		{
				sendOutput( msg.time(), stop, true ) ;
		}

		else if ( ifReset == true )
				sendOutput( msg.time(), onReset, true ) ;

		return *this ;
}
