/*******************************************************************
*
*  DESCRIPTION:
*
*  AUTHOR:
*
*  EMAIL:
*
*  DATE:
*
*******************************************************************/

/** include files **/
#include "counter.h"      // class Counter
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )

/** public functions **/

/*******************************************************************
* Function Name: Counter
* Description:
********************************************************************/
Counter::Counter( const string &name )
: Atomic( name )
, moveLeft( addInputPort( "moveLeft" ) )
, moveRight( addInputPort( "moveRight" ) )
, incr( addInputPort( "incr" ) )
, decr( addInputPort( "decr" ) )
, aisleLocked( addOutputPort( "aisleLocked" ) )
, onExit( addOutputPort( "onExit" ) )
, preparationTime( 0, 2, 0, 0 )
, initialTime( 0, 0, 0, 10 )

{
	
}

/*******************************************************************
* Function Name: initFunction
* Description:
* Precondition:
********************************************************************/
Model &Counter::initFunction()
{	
	countValue = 0;
	holdIn( passive, Time::Zero ) ;

	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &Counter::externalFunction( const ExternalMessage &msg )
{


	if ( msg.port() == incr )
		{
			countValue = 1 ;
		}


		else if ( msg.port() == decr )
		{
			countValue = 0 ;

		}

		else if ( ( msg.port() == moveLeft ) || ( msg.port() == moveRight )  )
		{
			if (countValue == 1)
			{
				ifLocked = true ;
				holdIn ( active, Time::Zero ) ;
			}

			else if ( countValue == 0 )
			{
				ifExit = true ;
				holdIn ( active, Time::Zero ) ;
			}
		}

	return *this ;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &Counter::internalFunction( const InternalMessage & )
{
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &Counter::outputFunction( const InternalMessage &msg )
{
		if ( ifLocked == true )
			{
					sendOutput( msg.time(), aisleLocked, true ) ;
			}

			else if ( ifExit == true )
					sendOutput( msg.time(), onExit, true ) ;

			return *this ;
}
