/********************************************************************
*																	*
*      				 Auto Generated File                            *
*                     												*		
*********************************************************************/

/** include files **/
#include "Low_Priority_Queue.h"           // base header
#include "message.h"       // InternalMessage ....
#include "mainsimu.h"      // class MainSimulator


/*******************************************************************
* Function Name: High_Priority_Queue
* Description: constructor
********************************************************************/
Low_Priority_Queue::Low_Priority_Queue( const string &name )
: Atomic( name )
, pkt_incl( addInputPort( "pkt_incl" ) )
, done_lo( addInputPort( "done_lo" ) )
, pkt_low_receiver( addOutputPort( "pkt_low_receiver" ) )
, preparationTime( 0, 0, 10, 0 )

{
	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

	if( time != "" )
		preparationTime = time ;
}


/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &Low_Priority_Queue::initFunction()
{
	elements.erase( elements.begin(), elements.end() ) ;
		return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This method executes when an external event is received.
********************************************************************/
Model &Low_Priority_Queue::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == pkt_incl )
			{
				elements.push_back( msg.value() ) ;
				//if( elements.size() == 1 )
					holdIn( active, preparationTime );
			}

			if(( msg.port() == done_lo ) && ( elements.size()>1 ))
			{
				elements.pop_front() ;
				if( !elements.empty() )
					holdIn( active, preparationTime );
			}

			return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description: This method executes when the TA has expired, right after the outputFunction has finished.
* 			   The new state and TA should be set.
********************************************************************/
Model &Low_Priority_Queue::internalFunction( const InternalMessage & )
{
	passivate();
			return *this ;

}

/*******************************************************************
* Function Name: outputFunction
* Description: This method executes when the TA has expired. After this method the internalFunction is called.
*              Output values can be send through output ports
********************************************************************/
Model &Low_Priority_Queue::outputFunction( const InternalMessage &msg )
{
	sendOutput( msg.time(), pkt_low_receiver, elements.front() ) ;
			return *this ;

}





