/********************************************************************
*																	*
*      				 Auto Generated File                            *
*                     												*		
*********************************************************************/

/** include files **/
#include "Classifier.h"           // base header
#include "message.h"       // InternalMessage ....
#include "distri.h"        // class Distribution
#include "mainsimu.h"      // class MainSimulator


/*******************************************************************
* Function Name: Classifier
* Description: constructor
********************************************************************/
Classifier::Classifier( const string &name )
: Atomic( name )
, packet_in_n( addInputPort( "packet_in_n" ) )
, ack_h( addInputPort( "ack_h" ) )
//, ack_l( addInputPort( "ack_l" ) )
, pkt_out_h( addOutputPort( "pkt_out_h" ) )
, pkt_out_l( addOutputPort( "pkt_out_l" ) )

, preparationTime( 0, 0, 10, 0 )

{
	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

	if( time != "" )
		preparationTime = time ;

	string time2( MainSimulator::Instance().getParameter( description(), "timeout" ) ) ;

	if( time2 != "" )
		timeout = time2 ;
}

/*******************************************************************
* Function Name: initFunction
********************************************************************/

Model &Classifier::initFunction()
{

	this-> passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This method executes when an external event is received.
********************************************************************/
Model &Classifier::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == packet_in_n  && this->state() == passive)
		{	totalPacketNum = static_cast < int > (msg.value());
			if (totalPacketNum > 0)
			{	packetNum = 1;
				cout << "packet number" << totalPacketNum << "\n";
				acko = false;
				sending = true;
				//priority_bit = packetNum % 2;	//set initial alt_bit
				holdIn(active, preparationTime );
			}
		}
		if( msg.port() == ack_h) //  && this->state() == active)
		{
		 acko = true;
		 sending = false;
		 holdIn(active, Time::Zero) ;
		}
return *this;

}
/*******************************************************************
* Function Name: internalFunction
* Description: This method executes when the TA has expired, right after the outputFunction has finished.
* 			   The new state and TA should be set.
********************************************************************/
Model &Classifier::internalFunction( const InternalMessage & )
{
	cout<<"in internal function packetNum "<< packetNum<< "\n";

	if (acko)
{	if (packetNum < totalPacketNum)
	{	packetNum++;
	    acko = false;
	    sending = true;
	    cout<<"in internal function sending "<< sending<< "\n";
		holdIn( active, preparationTime );
	}
	else
		passivate();
}
	else
    	passivate();
return *this;
}


Model &Classifier::outputFunction( const InternalMessage &msg )
{
 if (sending)
{
  sendOutput( msg.time(), pkt_out_l, packetNum ) ;

  sendOutput( msg.time(), pkt_out_h, (packetNum+1) );

}
return *this ;
}









