/*******************************************************************
*
*  DESCRIPTION: Atomic Model Loader
*
*  AUTHOR: Guillaume Plouffe
*
*  EMAIL: mailto://gplou010@uottawa.ca
*
*  DATE: 04/03/2016
*
*******************************************************************/

#ifndef __LoaderType_H
#define __LoaderType_H

/** include files **/
#include "atomic.h"  // class Atomic

/** forward declarations **/


/** declarations **/
class LoaderType: public Atomic
{
public:
	LoaderType( const string &name = "LoaderType" ) ;	 // Default constructor
	~LoaderType();					// Destructor
	virtual string className() const
		{return "LoaderType";}

protected:
	Model &initFunction();	
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	//inputs
	const Port &speedIn;
	const Port &next;
	const Port &done;

	//outputs
	Port &speedOut;
	Port &start;


	// Variables
	int readyToSend;
	int speed;

};	 //class LoaderType


#endif   //__LoaderType_H 
