/*******************************************************************
*
*  DESCRIPTION: Atomic Model Contractor
*
*  AUTHOR: Talal Bin Qamar
*
*  EMAIL: mailto://talalqamar@cmail.carleton.ca
*
*  DATE: 3/9/2016
*
*******************************************************************/

/** include files **/
#include "contractor.h"      // class Contractor
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"      // class MainSimulator

/** public functions **/

/*******************************************************************
* Function Name: Walkway
* Description:
********************************************************************/
Contractor::Contractor( const string &name )
: Atomic( name )
, snowAccOnW( addInputPort( "snowAccOnW" ) )
, snowAccSideW( addInputPort( "snowAccSideW" ) )
, snowAccOnR( addInputPort( "snowAccOnR" ) )
, snowAccSideR( addInputPort( "snowAccSideR" ) )
, vehicle1W( addOutputPort( "vehicle1W" ) )
, vehicle2W( addOutputPort( "vehicle2W" ) )
, vehicle1R( addOutputPort( "vehicle1R" ) )
, vehicle2R( addOutputPort( "vehicle2R" ) )
, snowRemoved( addOutputPort( "snowRemoved" ) )
, travelTime( 0, 0, 1, 0 )
{
	v1walkway = 0;
	v2walkway = 0;
	v1road = 0;
	v2road = 0;
	lastInputType = 0;
	totalSnowRemovedRoad = 0;
	totalSnowRemovedWalkway = 0;

}

/*******************************************************************
* Function Name: initFunction
*
********************************************************************/
Model &Contractor::initFunction()
{
	this-> passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &Contractor::externalFunction( const ExternalMessage &msg )
{


	if( msg.port() == snowAccOnW && !v2walkway)   // snow on walkway and vehivle type 2 is not active
	{
		lastInputType = 1;
		if(static_cast < int > (msg.value()) > 3 && !v1walkway)  // if higher than 3 cm then set vehicle to true
		{
			holdIn(active, travelTime );
			v1walkway = 1;

		}
		else if(static_cast < int > (msg.value()) == 0 && v1walkway) // if snow now 0 and vehicle was already sent then vehicle should return
				{
					holdIn(passive, travelTime );
					v1walkway = 0;
				}
		else
		{
			passivate();
		}
	}
	if( msg.port() == snowAccSideW && !v1walkway) // if snow on sideway
		{
		lastInputType = 2;
			if(static_cast < int > (msg.value()) > 25 && !v2walkway)  // if higher than 25 cm then set vehicle to true
			{
				holdIn(active, travelTime );
				totalSnowRemovedWalkway = static_cast < int > (msg.value() / 5) * 5  ;
				v2walkway = 1;

			}
			else if(static_cast < int > (msg.value()) <=5 && v2walkway) // if snow now 0 and vehicle was already sent then vehicle should return
					{
						holdIn(passive, travelTime );
						v2walkway = 0;
					}
			else
			{
				passivate();
			}
		}


	if( msg.port() == snowAccOnR && !v2road)   // snow on road and vehicle type 2 is not active
		{
			lastInputType = 3;
			if(static_cast < int > (msg.value()) > 3 && !v1road)  // if higher than 3 cm then set vehicle to true
			{
				holdIn(active, travelTime );
				v1road = 1;

			}
			else if(static_cast < int > (msg.value()) == 0  && v1road) // if snow now less than 5cm and vehicle was already sent then vehicle should return
					{
						holdIn(passive, travelTime );
						v1road = 0;
					}
			else
			{
				passivate();
			}
		}
		if( msg.port() == snowAccSideR && !v1road) // if snow on sideway
			{
			lastInputType = 4;
				if(static_cast < int > (msg.value()) > 25 && !v2road)  // if higher than 25 cm then set vehicle to true
				{
					holdIn(active, travelTime );
					totalSnowRemovedRoad = static_cast < int > (msg.value() / 7) * 7  ;
					v2road = 1;

				}
				else if(static_cast < int > (msg.value()) <= 8 && v2road) // if snow now less than 8cm and vehicle was already sent then vehicle should return
						{
							holdIn(passive, travelTime );
							v2road = 0;
						}
				else
				{
					passivate();
				}
			}


	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &Contractor::internalFunction( const InternalMessage & )
{
	passivate();
	return *this;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &Contractor::outputFunction( const InternalMessage &msg )
{


    if(v1walkway && this->state()==active && lastInputType ==1)
    {
    	sendOutput( msg.time(), vehicle1W, 1 ) ;
    }
    if(v2walkway && this->state()==active && lastInputType ==2)
	{
		sendOutput( msg.time(), vehicle2W, 1 ) ;
	}
    if(!v2walkway && this->state()==passive && lastInputType ==2)
    	{
    		sendOutput( msg.time(), snowRemoved, totalSnowRemovedWalkway ) ;
    	}
    if(v1road && this->state()==active && lastInputType ==3)
        {
        	sendOutput( msg.time(), vehicle1R, 1 ) ;
        }
    if(v2road && this->state()==active && lastInputType ==4)
            {
            	sendOutput( msg.time(), vehicle2R, 1 ) ;
            }
    if(!v2road && this->state()==passive && lastInputType ==4)
	{
		sendOutput( msg.time(), snowRemoved, totalSnowRemovedRoad ) ;
	}

	return *this ;
}

