/*******************************************************************
*
*  DESCRIPTION: Atomic Model Road
*
*  AUTHOR: Talal Bin Qamar
*
*  EMAIL: mailto://talalqamar@cmail.carleton.ca
*
*  DATE: 3/9/2016
*
*******************************************************************/

#ifndef __ROAD_H
#define __ROAD_H

#include "atomic.h"     // class Atomic




class Road : public Atomic
{
public:
	Road( const string &name = "Road" );				//Default constructor
	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &passiveMelt;
	const Port &snow;
	const Port &vehicle1;  // normal snow clearing vehicle
	const Port &vehicle2;  // normal snow removing vehicle (truck)
	Port &snowAccOn;
	Port &snowAccSide;
	Time clearingTimeOn;
	Time clearingTimeSide;
	int snowOn; // snow on the road
	int snowSide; // snow on the side of the road
	bool onVehicle;
	bool sideVehicle;

};	// class Walkway

// ** inline ** //
inline
string Road::className() const
{
	return "Road" ;
}

#endif   //__Road_H
