/*******************************************************************
*
*  DESCRIPTION: Atomic Model Walkway
*
*  AUTHOR: Talal Bin Qamar
*
*  EMAIL: mailto://talalqamar@cmail.carleton.ca
*
*  DATE: 3/9/2016
*
*******************************************************************/

/** include files **/
#include "walkway.h"      // class walkway
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"      // class MainSimulator

/** public functions **/

/*******************************************************************
* Function Name: Walkway
* Description:
********************************************************************/
Walkway::Walkway( const string &name )
: Atomic( name )
, passiveMelt( addInputPort( "passiveMelt" ) )
, snow( addInputPort( "snow" ) )
, vehicle1( addInputPort( "vehicle1" ) )
, vehicle2( addInputPort( "vehicle2" ) )
, snowAccOn( addOutputPort( "snowAccOn" ) )
, snowAccSide( addOutputPort( "snowAccSide" ) )
, clearingTimeOn( 0, 0, 4, 0 )  // clearing Time for  vehicle to remove snow on the walkway
, clearingTimeSide( 0, 0, 10, 0 ) // clearing Time for  vehicle to remove snow on the side
{
	snowOn = 0;
	snowSide = 0;
	onVehicle = 0;
	sideVehicle = 0;
}

/*******************************************************************
* Function Name: initFunction
*
********************************************************************/
Model &Walkway::initFunction()
{
	this-> passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &Walkway::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == snow )
	{
		snowOn = snowOn + static_cast < int > (msg.value());
		snowSide = snowSide + static_cast < int > (msg.value());
		holdIn(active, Time::Zero );
	}

	if( msg.port() == passiveMelt )
		{
			snowSide = snowSide - static_cast < int > (msg.value()) ;
			holdIn(active, Time::Zero );

		}
	if( msg.port() == vehicle1 )
	{
		onVehicle = 1;
		snowOn = snowOn - 2;
		snowSide = snowSide + 5;
		holdIn(active, clearingTimeOn );
	}

	if( msg.port() == vehicle2 )
		{
			sideVehicle = 1;
			snowSide = snowSide - 5;
			holdIn(active, clearingTimeSide );
		}

	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &Walkway::internalFunction( const InternalMessage & )
{
	if(this->state()==active && !onVehicle && sideVehicle)
	{
		if (snowSide>5)
		{
			snowSide = snowSide - 5;
			holdIn(active, clearingTimeSide );
		}
		else
		{
			sideVehicle = 0;
			this->passivate();
		}
		return *this;
	}

	if (this->state()== active && onVehicle)
		{
			if (snowOn > 0 )
			{
				snowOn = snowOn - 2;
				snowSide = snowSide + 5;
				holdIn(active, clearingTimeOn );
			}
			else
			{
				onVehicle = 0;
				this->passivate();
			}
			if (snowOn< 0)
				{
					onVehicle = 0;
					snowOn = 0;
					snowSide = snowSide - 1;
				}
		}
	else
	{
		this->passivate();
		if (snowOn< 0)
			{
				onVehicle = 0;
				snowOn = 0;
				snowSide = snowSide - 1;
			}
	}

	return *this;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &Walkway::outputFunction( const InternalMessage &msg )
{
    sendOutput( msg.time(), snowAccOn, snowOn ) ;
    sendOutput( msg.time(), snowAccSide, snowSide ) ;
	return *this ;
}

