/*******************************************************************
*
*  DESCRIPTION: Atomic Model Contractor
*
*  AUTHOR: Talal Bin Qamar
*
*  EMAIL: mailto://talalqamar@cmail.carleton.ca
*
*  DATE: 3/9/2016
*
*******************************************************************/

#ifndef __CONTRACTOR_H
#define __CONTRACTOR_H

#include "atomic.h"     // class Atomic
#include "message.h"

/** forward declarations **/


class Contractor : public Atomic
{
public:
	Contractor( const string &name = "Contractor" );				//Default constructor
	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &snowAccOnW; // snow accumulated on walkway
	const Port &snowAccSideW; // snow accumulated on side of walkway
	const Port &snowAccOnR; // snow accumulated on road
	const Port &snowAccSideR; // snow accumulated on side of road
	Port &vehicle1W;
	Port &vehicle2W;
	Port &vehicle1R;
	Port &vehicle2R;
	Port &snowRemoved;

	bool v1walkway;
	bool v2walkway;
	bool v1road;
	bool v2road;

	Time travelTime;
	int lastInputType; // int to store what type of input came last . 1 = snowAccOnW , 2 = snowAccSideW 3 = snowAccOnR 4 = snowAccSideR
	int totalSnowRemovedRoad;
	int totalSnowRemovedWalkway;

};	// class Contractor

// ** inline ** //
inline
string Contractor::className() const
{
	return "Contractor" ;
}

#endif   //__WALKWAY_H
