/*******************************************************************
*
*  DESCRIPTION: Atomic Model Road
*
*  AUTHOR: Talal Bin Qamar
*
*  EMAIL: mailto://talalqamar@cmail.carleton.ca
*
*  DATE: 3/9/2016
*
*******************************************************************/

/** include files **/
#include "road.h"      // class Subnet
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"      // class MainSimulator

/** public functions **/

/*******************************************************************
* Function Name: Walkway
* Description:
********************************************************************/
Road::Road( const string &name )
: Atomic( name )
, passiveMelt( addInputPort( "passiveMelt" ) )
, snow( addInputPort( "snow" ) )
, vehicle1( addInputPort( "vehicle1" ) )
, vehicle2( addInputPort( "vehicle2" ) )
, snowAccOn( addOutputPort( "snowAccOn" ) )
, snowAccSide( addOutputPort( "snowAccSide" ) )
, clearingTimeOn( 0, 0, 6, 0 )  // clearing Time for  vehicle to remove snow on the walkway
, clearingTimeSide( 0, 0, 13, 0 ) // clearing Time for  vehicle to remove snow on the side
{
	snowOn = 0;
	snowSide = 0;
	onVehicle = 0;
	sideVehicle = 0;
}

/*******************************************************************
* Function Name: initFunction
*
********************************************************************/
Model &Road::initFunction()
{
	this-> passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &Road::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == snow ) // add snow to snow on road and snow on side
	{
		snowOn = snowOn + static_cast < int > (msg.value());
		snowSide = snowSide + static_cast < int > (msg.value());
		holdIn(active, Time::Zero );
	}

	if( msg.port() == passiveMelt ) // subtract snow on side of the road
		{
			snowSide = snowSide - static_cast < int > (msg.value()) ;
			holdIn(active, Time::Zero );

		}
	if( msg.port() == vehicle1 )  // remove snow from road  by 3 cm and add 7 cm to side of road
	{
		onVehicle = 1;
		snowOn = snowOn - 3;
		snowSide = snowSide + 7;
		holdIn(active, clearingTimeOn );
	}

	if( msg.port() == vehicle2 ) // remove snow from side in steps of 7cm
		{
			sideVehicle = 1;
			snowSide = snowSide - 7;
			holdIn(active, clearingTimeSide );
		}

	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &Road::internalFunction( const InternalMessage & )
{
	if(this->state()==active && !onVehicle && sideVehicle) // if snow greater thatn 8 cm on side then keep clearing
	{
		if (snowSide>8)
		{
			snowSide = snowSide - 7;
			holdIn(active, clearingTimeSide );
		}
		else
		{
			sideVehicle = 0;
			this->passivate();
		}
		return *this;
	}

	if (this->state()== active && onVehicle) // if snow on road not zero keep clearing
		{
			if (snowOn > 0 )
			{
				snowOn = snowOn - 3;
				snowSide = snowSide + 7;
				holdIn(active, clearingTimeOn );
			}
			else
			{
				onVehicle = 0;
				this->passivate();
			}
			if (snowOn== -2) // speacial case when logic might return negative snow so adjusting the side level as that snow was never removed.
				{
					onVehicle = 0;
					snowOn = 0;
					snowSide = snowSide - 7;
				}
			if (snowOn== -1)
				{
					onVehicle = 0;
					snowOn = 0;
					snowSide = snowSide - 5;
				}
		}
	else
	{
		this->passivate();
		if (snowOn== -2)
			{
				onVehicle = 0;
				snowOn = 0;
				snowSide = snowSide - 7;
			}
		if (snowOn== -1)
			{
				onVehicle = 0;
				snowOn = 0;
				snowSide = snowSide - 5;
			}
	}

	return *this;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &Road::outputFunction( const InternalMessage &msg )
{
    sendOutput( msg.time(), snowAccOn, snowOn ) ;
    sendOutput( msg.time(), snowAccSide, snowSide ) ;
	return *this ;
}

