use strict;
use warnings;
use POSIX;

# For a M*N cells, we have (M+1)*(N+1) points to depict all the positions
# From left to right, from west to east,  that is easting, from 0 to N
# From up to dowm,  from north to south, that is southing, from 0 to M
#
# the geography information is stored in the geo.info file.

sub retrieve_geoinfo
{
   my ($geoinfo_array_ref)=@_;
   
   my $data_file="geo.info";
   my $easting;
   my $northing;
   my $line;
   
   open(my $fh,"<$data_file") or die("cannot open file $data_file \n");
   # we read the longitude and latitude information
   while( $line = <$fh> )
   {
	   #( 526 , 447 ) : -78.6091778575701 35.6946087969445 [longitude,latitude]
	   #[-+]?[0-9]*\.?[0-9]+
	   if($line =~ /\(\s*(\d*)\s*\S\s*(\d*)\s*\)\s*:\s*([-+]?[0-9]*\.?[0-9]*)\s*([-+]?[0-9]*\.?[0-9]*)/)
	   {
	      push( @{$geoinfo_array_ref->[$1][$2]} , $3);
	      push( @{$geoinfo_array_ref->[$1][$2]} , $4);
	      
	   }
   }
   close($fh);
}

1;