use strict;
use warnings;
use POSIX;

require "graphMerge.pl";
require "geoinfoRetrieve.pl";
require "cellsinfoRetrieve.pl";
require "kmlCreate.pl";

# you could config the following parameters
my $my_debug=0;
my $ma_file = "urbangrowth.ma";
my $outline = 0;
my $kml_file = "protype.kml" ;
my $log_file="urbangrowthLOG.log";

# Please don't touch the following configurations

###########################################
## stage1
# read the longitude and latitude geography information
my @geoinfo_array;

print "Stage1:begin to retrieve the geography information \n";
retrieve_geoinfo(\@geoinfo_array);
my $geoinfo_row_num = @geoinfo_array;
my $geoinfo_column_num = $#{$geoinfo_array[0]}+1;

print "\t"."the georgraphy information has $geoinfo_row_num rows and $geoinfo_column_num columns \n";

## stage2
print "Stage2:begin to retrieve the cell information \n";
# retrieve the cells information, incuding the size, the initial value
# for now, we supporting two dimensional and three dimensional cells
my @cells_matrix;
retrieve_cells_info(\@cells_matrix,$ma_file);
my $cells_layer_num = @cells_matrix;
my $cells_row_num = $#{$cells_matrix[0]} + 1;
my $cells_column_num = $#{$cells_matrix[0][0]} + 1;

print "\t"."the cells matrix has $cells_layer_num layers,$cells_row_num rows, $cells_column_num columns \n";

## stage3
print "Stage3:Check configuration information\n";

my @state_style_array;
my @index_map_state;
my $count_style = gather_states_num(\@cells_matrix);

# it will read cell.style file to retrieve the information
my $count_style2 = gather_state_style(\@state_style_array,\@index_map_state);

#check whether we provide the enough colour tables for the style
if($count_style!=$count_style2)
{
	print "\t"."need more style for different cell states \n";
	exit;
}

## stage4
## create kml
print "Stage4: generate the kml \n";

my $kml_text = "" ;
initiate_kml(\$kml_text,\@state_style_array,\@index_map_state,$outline);
body_kml(\$kml_text, \@cells_matrix, $log_file,\@state_style_array,\@index_map_state,\@geoinfo_array);
end_kml(\$kml_text);

open( KML , ">$kml_file" ) or die "Could not open $kml_file for writing\n";
print KML $kml_text ;
close( KML );

1;